/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFont.h,v 1.3 1999/09/20 01:27:07 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CFont_h	// [
#define Included_CFont_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CFont

class CFont
{
	NOT_COPYABLE(CFont)

public:
	CFont();
	CFont(HFONT font);
	CFont(const LOGFONT& logFont);
	~CFont();

	CFont&	operator=(HFONT font);

	operator HFONT() const {return mFont;}
	HFONT	Get() const {return mFont;}

	void	GetLogFont(LOGFONT& logFont) const;

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	void	CreateIndirect(const LOGFONT& logFont);
	void	Attach(HFONT font);
	void	Clear();

private:
	PGPBoolean	mWeCreated;
	HFONT		mFont;
};


// Class CFont member functions

inline 
CFont::CFont() : mWeCreated(FALSE), mFont(NULL)
{
}

inline 
CFont::CFont(HFONT font) : mWeCreated(FALSE), mFont(NULL)
{
	Attach(font);
}

inline 
CFont::CFont(const LOGFONT& logFont) : mWeCreated(FALSE), mFont(NULL)
{
	CreateIndirect(logFont);
}

inline 
CFont::~CFont()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
CFont& 
CFont::operator=(HFONT font)
{
	Attach(font);
	return *this;
}

inline 
void 
CFont::GetLogFont(LOGFONT& logFont) const
{
	if (GetObject(mFont, sizeof(logFont), &logFont) == 0)
		THROW_PGPERROR(kPGPError_GraphicsOpFailed);
}

inline 
PGPBoolean 
CFont::IsAttached() const
{
	return IsntNull(mFont);
}

inline 
void 
CFont::CreateIndirect(const LOGFONT& logFont)
{
	Clear();
	mFont = CreateFontIndirect(&logFont);

	if (IsNull(mFont))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

inline 
void 
CFont::Attach(HFONT font)
{
	if (mFont == font)
		return;

	Clear();

	mWeCreated = FALSE;
	mFont = font;
}

inline 
void 
CFont::Clear()
{
	if (WeCreated())
		DeleteObject(mFont);

	mWeCreated = FALSE;
	mFont = NULL;
}

_PGP_END

#endif	// ] Included_CFont_h
